/****************************************************************************
 * MyStd -- Defined general, global stuff all files in Viola algorithms use *
 ****************************************************************************
 * Points of Style and Conventions:                                         *
 *                                                                          *
 *   m, n: Pattern/Cluster Index                                            *
 *   k: GausLevel Index                                                     *
 *   i, j: Feature Index                                                    *
 *                                                                          *
 *   model: the in-class histogram; antim: the out-of class histogram       *
 *   class: an undetermined histogram; img, cluster, hist, pattern          *
 *                                                                          *
 *   Function that return pointers allocated/reserved memory                *
 *   Functions that take pointers will save and later free the memory       *
 *   Functions that take references to pointers save them but don't free    *
 ****************************************************************************/

#ifndef MYSTD_H
#define MYSTD_H

// To do: See how well works with non-oriented filters (gradient magnitude,
//	    other derivitives), also orientations of those, wavelet responses
//        Add capability to use many in and out of class images
//        Look for other methods to analyze faster
//        Use Boxcar Parzen density kernel (Flexible Histograms: ...) to
//	    simplify calculation.  Also, produce set of functions for following
//	    their algorithm as closely as possible
//        Finish input and output of clusters

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <iostream.h>

#include <Array.h>
#include <List.h>

#define smallval 1e-5
#define midval 1
#define largeval 1e5

#define floor(a) ((int) (a))
#define frand()  ((double) rand() / 32768.0)
#define sqr(a)   ((a) * (a))

#endif
