/****************************************************************************
 * System -- All the information for a complete model comparison            *
 ****************************************************************************
 * A probability system may be composed of multiple models, each with mult- *
 * iple histograms, refined to predict instances of the various classes.    *
 *                                                                          *
 ****************************************************************************/

#ifndef SYSTEM_H
#define SYSTEM_H

class System;

#include "model.h"
#include "histogram.h"
#include "pattern.h"

class System {
public:
  System();
  System(Model *in, Model *out);
  ~System();

  Model &GetStandardModel(); // Creates standard model, if doesn't exist
  Model &GetContrastModel(); // returns last non-first model, possibly creating

  unsigned GetModelCount();
  void SetModelCount(unsigned count);
  Model &GetModel(unsigned id);
  void AddModel(Model *newmodel);
  void AddModel();

  // Final Image Classification Probabilities
  double EntropyProb(const CArray<Pattern *, Pattern *> &pats);
  double ChiSqrProb(const CArray<Pattern *, Pattern *> &pats);
  double PatternProb(const CArray<Pattern *, Pattern *> &pats);

  static double BayesRule(double modelprob, double antiprob);

private:
  CList<Model *, Model *> models;
};

#endif
