//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: Archive.h
// Author: Daniel Tschan (d.tschan@switzerland.org)
// Created: 01-15-98
// Last modified: 01-15-98
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// CArchive class. Used for object serialization.

#include <Archive.h>
#include <Object.h>
#include <DummyFile.h>

CArchive::CArchive( CFile* pFile, unsigned int nMode, CClassFactory* pClassFactory )
{
  m_pFile = pFile;
  m_nMode = nMode;
  m_pClassFactory = pClassFactory;
}

CArchive& operator>>( CArchive& ar, CObject*& pOb )
{
  int nClassID;
  ar >> nClassID;
  pOb = ar.m_pClassFactory->CreateInstance( nClassID );
  
  pOb->Serialize( ar );

  return ar;
}

/*CArchive& operator>>( CArchive& ar, const CObject*& pOb )
{
  int nClassID;
  ar >> nClassID;
  pOb = ar.m_pClassFactory->CreateInstance( nClassID );
  
  pOb->Serialize( ar );

  return ar;
}*/


CArchive& operator<<( CArchive& ar, const CObject* pOb )
{
  ar << pOb->ClassID( );
  ( ( CObject* ) pOb )->Serialize( ar );

  return ar;
}

int CArchive::Size( const CObject* pOb )
{
  CFile* pFile = m_pFile;
  m_pFile = new CDummyFile( );

  *this << pOb;

  int nSize = m_pFile->GetPosition( );

  delete m_pFile;
  m_pFile = pFile;  

  return nSize;
}
