//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: Archive.h
// Author: Daniel Tschan (d.tschan@switzerland.org)
// Created: 01-15-98
// Last modified: 01-15-98
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// CArchive class. Used for object serialization.

#ifndef __ARCHIVE_H__
#define __ARCHIVE_H__

#include <Decls.h>
#include <Object.h>
#include <ClassFactory.h>
#include <File.h>
#include <StrClass.h>

class CArchive
{
public:
  // Construction
  CArchive( CFile* pFile, UINT nMode, CClassFactory* pClassFactory = NULL ); // int nBufSize = 4096, void* lpBuf = NULL );
  // void Abort( );
  // void Close( );

  // Basic Input/Output
  // void Flush( );
  friend CArchive& operator>>( CArchive& ar, CObject*& pOb );
  // friend CArchive& operator >>( CArchive& ar, const CObject*& pOb );
  CArchive& operator >>( BYTE& by );
  CArchive& operator >>( int& i );
  CArchive& operator >>( long& l );
  CArchive& operator >>( float& f );
  CArchive& operator >>( double& d );
  friend CArchive& operator<<( CArchive& ar, const CObject* pOb );
  CArchive& operator <<( BYTE by );
  CArchive& operator <<( int i );
  CArchive& operator <<( long l );
  CArchive& operator <<( float f );
  CArchive& operator <<( double d );
  unsigned int Read( void* lpBuf, unsigned int nMax );
  void Write( const void* lpBuf, UINT nMax );
  int Size( const CObject* pOb );
  /*void WriteString( LPCTSTR lpsz );
  BOOL ReadString(CString& rString );
  const char* ReadString( LPTSTR lpsz, UINT nMax );*/

  // Status
  CFile* GetFile( ) const;
  BOOL IsLoading( ) const;
  BOOL IsStoring( ) const;

  enum Mode { store = 0, load = 1, bNoFlushOnDelete = 2, bNoByteSwap = 4 };

private:
  CFile* m_pFile;
  unsigned int m_nMode;
  CClassFactory* m_pClassFactory;
};

CArchive& operator>>( CArchive& ar, CObject*& pOb );

inline CArchive& CArchive::operator>>( BYTE& by )
{
  m_pFile->Read( &by, sizeof( BYTE ) );

  return *this;
}

inline CArchive& CArchive::operator>>( int& i )
{
  m_pFile->Read( &i, sizeof( int ) );

  return *this;
}

inline CArchive& CArchive::operator>>( long& l )
{
  m_pFile->Read( &l, sizeof( long ) );

  return* this;
}

inline CArchive& CArchive::operator>>( float& f )
{
  m_pFile->Read( &f, sizeof( float ) );

  return *this;
}

inline CArchive& CArchive::operator>>( double& d )
{
  m_pFile->Read( &d, sizeof( double ) );

  return *this;
}

inline CArchive& CArchive::operator<<( BYTE by )
{
  m_pFile->Write( &by, sizeof( BYTE ) );

  return *this;
}

inline CArchive& CArchive::operator<<( int i )
{
  m_pFile->Write( &i, sizeof( int ) );

  return *this;
}

inline CArchive& CArchive::operator<<( long l )
{
  m_pFile->Write( &l, sizeof( long ) );

  return *this;
}

inline CArchive& CArchive::operator<<( float f )
{
  m_pFile->Write( &f, sizeof( float ) );

  return *this;
}

inline CArchive& CArchive::operator<<( double d )
{
  m_pFile->Write( &d, sizeof( double ) );

  return *this;
}

inline unsigned int CArchive::Read( void* lpBuf, unsigned int nMax )
{
  return m_pFile->Read( lpBuf, nMax );
}

inline void CArchive::Write( const void* lpBuf, UINT nMax )
{
  m_pFile->Write( lpBuf, nMax );
}
  
inline CFile* CArchive::GetFile( ) const
{
  return m_pFile;
}

inline BOOL CArchive::IsLoading( ) const
{
  return ( m_nMode & CArchive::load ) != 0;
}

inline BOOL CArchive::IsStoring( ) const
{
  return ( m_nMode & CArchive::load ) == 0;
}

template< class TYPE >
void SerializeElements( CArchive& ar, TYPE* pElements, int nCount )
{
  // default is bit-wise read/write
  if ( ar.IsStoring( ) )
    ar.Write( ( void* ) pElements, nCount * sizeof( TYPE ) );
  else
    ar.Read( ( void* ) pElements, nCount * sizeof( TYPE ) );
}

inline void SerializeElements( CArchive& ar, CString* pElements, int nCount )
{
  if ( ar.IsStoring( ) )
  {
    for ( ; nCount--; pElements++ )
      ar << *pElements;
  }
  else
  {
    for ( ; nCount--; pElements++ )
      ar >> *pElements;
  }
}

#endif   // __ARCHIVE_H__
