//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: Buffer.cpp
// Author: Daniel Tschan (d.tschan@switzerland.org)
// Created: 11-08-97
// Last modified: 11-09-97
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// Low-level class for buffer managing.

#include <Buffer.h>

// Better versions for intrinsics

CBuffer< char >& CBuffer< char >::operator=( const CBuffer< char >& rOther )
{
  Realloc( rOther.m_nSize );
  memcpy( m_pData, rOther.m_pData, rOther.m_nSize * sizeof( char ) );

  return *this;
}

CBuffer< short >& CBuffer< short >::operator=( const CBuffer< short >& rOther )
{
  Realloc( rOther.m_nSize );
  memcpy( m_pData, rOther.m_pData, rOther.m_nSize * sizeof( char ) );

  return *this;
}

CBuffer< int >& CBuffer< int >::operator=( const CBuffer< int >& rOther )
{
  Realloc( rOther.m_nSize );
  memcpy( m_pData, rOther.m_pData, rOther.m_nSize * sizeof( int ) );

  return *this;
}

CBuffer< long >& CBuffer< long >::operator=( const CBuffer< long >& rOther )
{
  Realloc( rOther.m_nSize );
  memcpy( m_pData, rOther.m_pData, rOther.m_nSize * sizeof( long ) );

  return *this;
}

CBuffer< float >& CBuffer< float >::operator=( const CBuffer< float >& rOther )
{
  Realloc( rOther.m_nSize );
  memcpy( m_pData, rOther.m_pData, rOther.m_nSize * sizeof( float ) );

  return *this;
}

CBuffer< double >& CBuffer< double >::operator=( const CBuffer< double >& rOther )
{
  Realloc( rOther.m_nSize );
  memcpy( m_pData, rOther.m_pData, rOther.m_nSize * sizeof( double ) );

  return *this;
}
