#include <stdlib.h>
#include <fstream.h>
#include <CGI.h>

void CCgi::Init( )
{
  if ( RequestMethod( ) == POST )
  {
    m_pszInput = new char[ ContentLength( ) + 1 ];
    cin >> m_pszInput;
  }
  else
  {
    if ( QueryString( ) != NULL )
    {
      m_pszInput = new char[ strlen( QueryString( ) ) + 1 ];
      strcpy( m_pszInput, QueryString( ) );
    }
    else
    {
      m_pszInput = new char[ 1 ];
      *m_pszInput = '\0';
    }
  }
  if ( *m_pszInput )
    m_pszInputPos = m_pszInput;
  else
    m_pszInputPos = NULL;
}

CCgi::~CCgi( )
{
  delete [ ] m_pszInput;
}

void CCgi::SetContentType( int nContentType )
{
  char* m_pszContentType[ ] = { "Content-type: text/html\n\n", "Content-type: image/jpeg\n\n",
    "Content-type: image/gif\n\n", "Content-type: java/*\n\n" };
  
  m_rOut << m_pszContentType[ nContentType ];
}

void CCgi::WriteFile( const CString& strFile )
{
  ifstream file( strFile, ios::in | ios::binary );

  file.seekg( 0, ios::end ); 
  int nSize = file.tellg( );
  file.seekg( 0, ios::beg );
  CString strBuf;
  file.read( strBuf.GetBuffer( nSize ), nSize );
  strBuf.ReleaseBuffer( );
  //  m_rOut << bin;   // Switch to binary mode
  m_rOut.write( strBuf, nSize );
}

CCgi& CCgi::operator>>( CString& strBuffer )
{
  *this >> strBuffer.GetBuffer( 1024 );
  strBuffer.ReleaseBuffer( );
  strBuffer.FreeExtra( );

  return *this;
}

CCgi& CCgi::operator>>( char* pszBuffer )
{
  if ( !m_pszInputPos )
    return *this;

  char* pszStart = strchr( m_pszInputPos, '=' );
  char* pszEnd = strchr( m_pszInputPos, '&' );

  if ( pszEnd )
  {
    *pszEnd = '\0';
    m_pszInputPos = pszEnd + 1;
  }
  else
    m_pszInputPos = NULL;

  if ( pszStart )
    strcpy( pszBuffer, pszStart + 1 );
 
  return *this;
}

CCgi& CCgi::operator>>( int& nNumber )
{
  if ( !m_pszInputPos )
    return *this;

  char* pszStart = strchr( m_pszInputPos, '=' );
  char* pszEnd = strchr( m_pszInputPos, '&' );

  if ( pszEnd )
  {
    *pszEnd = '\0';
    m_pszInputPos = pszEnd + 1;
  }
  else
    m_pszInputPos = NULL;

  if ( pszStart )
    nNumber = atoi( pszStart + 1 );
  
  return *this;
}
