#include <iostream.h>
#include <stdlib.h>
#include <StrClass.h>

class CCgi
{
public:
  enum METHOD { GET, POST };
  enum CONTENT_TYPE { HTML, JPEG, GIF, CLASS };
  CCgi( ostream& rStream = cout );
  ~CCgi( );
  void Init( );
  void SetContentType( int nContentType );
  void WriteFile( const CString& strFile );
  int eof( );
  CCgi& operator<<( CCgi& ( *fn )( CCgi& ) );
  CCgi& operator<<( int n );
  CCgi& operator<<( const char* pszText );
  CCgi& operator>>( char* pszBuffer );
  CCgi& operator>>( CString& strBuffer );
  CCgi& operator>>( int& nNumber );
  void SkipWords( int nWords );
  const char* ServerSoftware( );
  const char* ServerName( );
  const char* GatewayInterface( );
  const char* RemoteUser( );
  const char* RemoteIdent( );
  const char* RemoteHost( );
  const char* RemoteAddr( );
  const char* ServerProtocol( );
  const char* ServerPort( );
  int RequestMethod( );
  const char* PathInfo( );
  const char* PathTranslated( );
  const char* ScriptName( ); 
  const char* QueryString( );
  const char* AuthType( );
  const char* ContentType( );
  int ContentLength( );
  const char* HTTPAccept( );
  const char* HTTPUserAgent( );
  const char* SSIDocumentName( );
  const char* SSIDocumentURI( );
  const char* SSIQueryStringUnescaped( );
  const char* SSIDateLocal( );
  const char* SSIDateGMT( );
  const char* SSILastModified( );

private:
  CCgi& operator=( const CCgi& );

private:
  ostream& m_rOut;
  char* m_pszInput;
  char* m_pszInputPos;
};

inline CCgi& CCgi::operator=( const CCgi& )
{
  // CCgi objects must not be coppied, pass them by reference
  ASSERT( FALSE );

  return *this;
}

inline CCgi::CCgi( ostream& rStream ) : m_rOut( rStream )
{
  Init( );
}

inline int CCgi::eof( )
{
  return m_pszInputPos == NULL;
}

inline CCgi& CCgi::operator<<( int n )
{
  m_rOut << n;

  return *this;
}

inline CCgi& CCgi::operator<<( const char* pszText )
{
  if ( pszText )
    m_rOut << pszText;

  return *this;
}

inline CCgi& CCgi::operator<<( CCgi& ( *fn )( CCgi& ) )
{
  ( *fn )( *this );

  return *this;
}

inline const char* CCgi::ServerSoftware( )
{
  return getenv( "SERVER_SOFTWARE" );
}

inline const char* CCgi::ServerName( )
{
  return getenv( "SERVER_NAME" );
}

inline const char* CCgi::GatewayInterface( )
{
  return getenv( "GATEWAY_INTERFACE" );
}

inline const char* CCgi::ServerProtocol( )
{
  return getenv( "SERVER_PROTOCOL" );
}

inline const char* CCgi::ServerPort( )
{
  return getenv( "SERVER_PORT" );
}

inline int CCgi::RequestMethod( )
{
  char* pchRequestMethod = getenv( "REQUEST_METHOD" );
  if ( pchRequestMethod == NULL || !strcmp( pchRequestMethod, "GET" ) )
    return GET;
  else
    return POST;
}

inline const char* CCgi::PathInfo( )
{
  return getenv( "PATH_INFO" );
}

inline const char* CCgi::PathTranslated( )
{
  return getenv( "PATH_TRANSLATED" );
}

inline const char* CCgi::ScriptName( )
{
  return getenv( "SCRIPT_NAME" );
}

inline const char* CCgi::QueryString( )
{
  return getenv( "QUERY_STRING" );
}

inline const char* CCgi::RemoteHost( )
{
  return getenv( "REMOTE_HOST" );
}

inline const char* CCgi::RemoteAddr( )
{
  return getenv( "REMOTE_ADDR" );
}

inline const char* CCgi::AuthType( )
{
  return getenv( "AUTH_TYPE" );
}

inline const char* CCgi::RemoteUser( )
{
  return getenv( "REMOTE_USER" );
}

inline const char* CCgi::RemoteIdent( )
{
  return getenv( "REMOTE_IDENT" );
}

inline const char* CCgi::ContentType( )
{
  return getenv( "CONTENT_TYPE" );
}

inline int CCgi::ContentLength( )
{
  return atoi( getenv( "CONTENT_LENGTH" ) );
}

inline const char* CCgi::HTTPAccept( )
{
  return getenv( "HTTP_ACCEPT" );
}

inline const char* CCgi::HTTPUserAgent( )
{
  return getenv( "HTTP_USER_AGENT" );
}

inline const char* CCgi::SSIDocumentName( )
{
  return getenv( "DOCUMENT_NAME" );
}

inline const char* CCgi::SSIDocumentURI( )
{
  return getenv( "DOCUMENT_URI" );
}

inline const char* CCgi::SSIQueryStringUnescaped( )
{
  return getenv( "QUERY_STRING_UNESCAPED" );
}

inline const char* CCgi::SSIDateLocal( )
{
  return getenv( "DATE_LOCAL" );
}

inline const char* CCgi::SSIDateGMT( )
{
  return getenv( "DATE_GMT" );
}

inline const char* CCgi::SSILastModified( )
{
  return getenv( "LAST_MODIFIED" );
}

inline CCgi& endl( CCgi& rCgi )
{
  return rCgi << "<br>\n";
}

