//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: Decls.h
// Author: Daniel Tschan (d.tschan@switzerland.org)
// Created: 10-13-97
// Last modified: 10-13-97
//
// This file contains global declarations of the TML

#ifndef __DECLS_H__
#define __DECLS_H__

#include <assert.h>
#include <iostream.h>

// Position type for iteration
typedef void* POSITION;

// Define BOOL type if not already defined
#if !defined( BOOL )
typedef int BOOL;
#define FALSE 0
#define TRUE 1
#endif

// Define UINT type if not already defined
#if !defined( UINT )
typedef unsigned int UINT;
#endif

// Define BYTE type if not already defined
#if !defined( BYTE )
typedef unsigned char BYTE;
#endif

// Define WORD type if not already defined
#if !defined( WORD )
typedef unsigned short WORD;
#endif

// Define DWORD type if not already defined
#if !defined( DWORD )
typedef unsigned long DWORD;
#endif

// Define NULL pointer if not already defined
#ifndef NULL
  #define NULL 0
#endif

#ifndef min
template< class TYPE >
inline TYPE min( TYPE a, TYPE b )
{
  if ( a < b )
    return a;
  else
    return b;
}
#endif

#ifndef max
template< class TYPE >
inline TYPE max( TYPE a, TYPE b )
{
  if ( a > b )
    return a;
  else
    return b;
}
#endif

/////////////////////////////////////////////////////////////////////////////
// Define assertion macros for debug version
// 
// ASSERT_VALID( pObject ): Checks the class invariant of pObject by calling
//                          the AssertValid member function of pObject.
//                          It does nothing in Release-Versions.
//
// ASSERT( f ): Works like the assert makro. But if it was called from within
//              ASSERT_VALID it tells you on which line ASSERT_VALID was
//              called. It does nothing in Release-Versions.
#ifdef NDEBUG
  #define ASSERT_VALID( pObject )
  #define ASSERT( f )
#else
  extern int _nAssertLine;
  extern char* _pszFile;

  #define ASSERT_VALID( pObject ) \
    _nAssertLine = __LINE__, \
    _pszFile = (char*) __FILE__, \
    ( pObject )->AssertValid( ), \
    _nAssertLine = 0
  
  #define ASSERT( f ) \
    ( !( f ) && _nAssertLine ) ? \
    ( cout << "AssertValid called in file " << _pszFile \
	   << " on line: " << _nAssertLine << endl, 0 ) : \
      0, assert( f )
#endif

#endif // __DECLS_H__
