#ifndef __DUMMYFILE_H__
#define __DUMMYFILE_H__

#include <File.h>

class CDummyFile : public CFile
{
public:
  // Construction
  CDummyFile( );
  virtual ~CDummyFile( );
  
  virtual BOOL Open( const char* lpszFileName, unsigned int nOpenFlags ); //, CFileException* pError = NULL );
  virtual void Close( );

  // Input/Output
  virtual unsigned int Read( void* lpBuf, unsigned int nCount );
  virtual void Write( const void* lpBuf, unsigned int nCount );
  
  // Position
  virtual long Seek( long lOff, unsigned int nFrom );
  virtual unsigned int GetLength( ) const;
  
  // Status
  virtual unsigned int GetPosition( ) const;
  
public:
  int m_nFilePos;
};

inline CDummyFile::CDummyFile( )
{
  m_nFilePos = 0;
}
  
inline CDummyFile::~CDummyFile( )
{
}

inline BOOL CDummyFile::Open( const char* lpszFileName, unsigned int nOpenFlags )
{
  return TRUE;
}
  
inline void CDummyFile::Close( )
{
}

inline unsigned int CDummyFile::Read( void* lpBuf, unsigned int nCount )
{
  return nCount;
}

inline void CDummyFile::Write( const void* lpBuf, unsigned int nCount )
{
  m_nFilePos += nCount;
}

inline long CDummyFile::Seek( long lOff, unsigned int nFrom )
{
  return 0;
}

inline unsigned int CDummyFile::GetPosition( ) const
{
  return m_nFilePos;
}

inline unsigned int CDummyFile::GetLength( ) const
{
  return 0;
}

#endif   // __DUMMYFILE_H__
