#include <File.h>

CFile::CFile( )
{
  m_hFile = hFileNull;
}

CFile::CFile( int hFile )
{
  m_hFile = hFile;
}

CFile::CFile( const char* lpszFileName, unsigned int nOpenFlags )
{
  Open( lpszFileName, nOpenFlags );
}

CFile::~CFile( )
{
  Close( );
}

BOOL CFile::Open( const char* lpszFileName, unsigned int nOpenFlags )
{
  int nPermissions;
  if ( nOpenFlags & modeReadWrite )
    nPermissions = O_RDWR;
  else if ( nOpenFlags & modeWrite )
    nPermissions = O_WRONLY;
  else
    nPermissions = O_RDONLY;

  if ( nOpenFlags & modeCreate )
#ifdef _WIN32
    m_hFile = open( lpszFileName, nPermissions | O_CREAT | O_TRUNC | O_BINARY, S_IWRITE | S_IREAD );
#else
    m_hFile = open( lpszFileName, nPermissions | O_CREAT | O_TRUNC, S_IWRITE | S_IREAD );
#endif
  else
#ifdef _WIN32
    m_hFile = open( lpszFileName, nPermissions | O_BINARY );
#elseif
    m_hFile = open( lpszFileName, nPermissions ); 
#endif

  return m_hFile != -1;
}

unsigned int CFile::GetLength( ) const
{
  unsigned int nPos = lseek( m_hFile, 0, SEEK_CUR );
  unsigned int nLength = lseek( m_hFile, 0, SEEK_END );
  lseek( m_hFile, nPos, begin );

  return nLength;
}
