#ifndef __FILE_H__
#define __FILE_H__

#ifdef _WIN32
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#else
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#endif
#include <fcntl.h>
#include <stdio.h>
#include <Decls.h>

class CFile
{
public:
  // Flag values
  enum OpenFlags {
    modeRead =          0x0000,
    modeWrite =         0x0001,
    modeReadWrite =     0x0002,
    shareCompat =       0x0000,
    shareExclusive =    0x0010,
    shareDenyWrite =    0x0020,
    shareDenyRead =     0x0030,
    shareDenyNone =     0x0040,
    modeNoInherit =     0x0080,
    modeCreate =        0x1000,
    modeNoTruncate =    0x2000,
    typeText =          0x4000, // typeText and typeBinary are used in
    typeBinary =   (int)0x8000 // derived classes only
    };

  enum SeekPosition { begin = 0x0, current = 0x1, end = 0x2 };

  enum { hFileNull = -1 };

public:
  // Construction
  CFile( );
  CFile( int hFile );
  CFile( const char* lpszFileName, unsigned int nOpenFlags );
  virtual ~CFile( );
  /*virtual void Abort( );
  virtual CFile* Duplicate( ) const;*/
  virtual BOOL Open( const char* lpszFileName, unsigned int nOpenFlags ); //, CFileException* pError = NULL );
  virtual void Close( );

  // Input/Output
  virtual unsigned int Read( void* lpBuf, unsigned int nCount );
  // DWORD ReadHuge( void* lpBuffer, DWORD dwCount );
  virtual void Write( const void* lpBuf, unsigned int nCount );
  // void WriteHuge( const void* lpBuf, DWORD dwCount );
  // virtual void Flush( );

  // Position
  virtual long Seek( long lOff, unsigned int nFrom );
  void SeekToBegin( );
  unsigned int SeekToEnd( );
  virtual unsigned int GetLength( ) const;
  // virtual void SetLength( unsigned int nNewLen );
  
  // Status
  virtual unsigned int GetPosition( ) const;
  // virtual CString GetFileName( ) const;
  // virtual CString GetFileTitle( ) const;
  // virtual CString GetFilePath( ) const;
  // virtual void SetFilePath( const char* lpszNewName );

  // Static
  static void Rename( const char* lpszOldName, const char* lpszNewName );
  static void Remove( const char* lpszFileName );
  
public:
  int m_hFile;
};
 
inline void CFile::Close( )
{
  close( m_hFile );
}

inline unsigned int CFile::Read( void* lpBuf, unsigned int nCount )
{
  return read( m_hFile, lpBuf, nCount );
}

inline void CFile::Write( const void* lpBuf, unsigned int nCount )
{
  write( m_hFile, lpBuf, nCount );
}

/*inline void CFile::Flush( )
{
  _commit( m_hFile );
}*/

inline long CFile::Seek( long lOff, unsigned int nFrom )
{
  return lseek( m_hFile, lOff, nFrom );
}

inline void CFile::SeekToBegin( )
{
  lseek( m_hFile, 0, SEEK_SET );
}

inline unsigned int CFile::SeekToEnd( )
{
  return lseek( m_hFile, 0, SEEK_END );
}

inline unsigned int CFile::GetPosition( ) const
{
#ifdef _WIN32
  return tell( m_hFile );
#else
  return lseek( m_hFile, 0, SEEK_CUR );
#endif
}

inline void CFile::Rename( const char* lpszOldName, const char* lpszNewName )
{
  rename( lpszOldName, lpszNewName );
}

inline void CFile::Remove( const char* lpszFileName )
{
  remove( lpszFileName );
}

#endif   // __FILE_H__
