//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: HTMLParser.cpp
// Author: Daniel Tschan
// Created: 10-13-97
// Last modified: 10-23-97
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// This file contains the implementation of the HTML parser class.

#include <string.h>
#include <fstream.h>
#include <HTMLParser.h>

CHTMLParser::CHTMLParser( ) : CCgi( )
{
}

void CHTMLParser::RegisterToken( CString strToken, TOKEN_FUNCTION pfnToken )
{
  m_strTokens.Add( strToken );
  m_pfnTokens.Add( pfnToken );
}

void CHTMLParser::RegisterEnhancedToken( CString strToken, char chDelimiter, TOKEN_FUNCTION pfnToken )
{
  m_strEnhancedTokens.Add( strToken );
  m_chDelimiters.Add( chDelimiter );
  m_pfnEnhancedTokens.Add( pfnToken );
}

void CHTMLParser::RegisterBlock( CString strStart, CString strEnd, TOKEN_FUNCTION pfnToken )
{
  m_strBlockStarts.Add( strStart );
  m_strBlockEnds.Add( strEnd );
  m_pfnBlocks.Add( pfnToken );
}

void CHTMLParser::Parse( const CString& strFile, int nData )
{  
  if ( strFile.Find( ".gif" ) >= 0 )
  {
    SetContentType( GIF );
    WriteFile( strFile );
    return;
  }
  else if ( strFile.Find( ".jpg" ) >= 0 )
  {
    SetContentType( JPEG );
    WriteFile( strFile );
    return;
  }
  else if ( strFile.Find( ".class" ) >= 0 )
  {
    SetContentType( CLASS );
    WriteFile( strFile );
    return;
  }
  
  SetContentType( HTML );

  int i;
  BOOL bFound;
  CString strToken, strLine;
  int nTokenPos, nEnhTokenPos, nBlockPos;
  int nPos1, nPos2, nPos;
  ifstream iFile( strFile );
  while ( !iFile.eof( ) )
  {
    iFile.getline( strLine.GetBuffer( 1024 ), 1024 );
    strLine.ReleaseBuffer( );
    
    nTokenPos = nEnhTokenPos = nBlockPos = -1;
    do
    {      
      bFound = false;
      for ( i = 0; i < m_strBlockStarts.GetSize( ); i++ )
      {
        if ( ( nPos = strLine.Find( m_strBlockStarts[ i ], nBlockPos + 1 ) ) >= 0 )
        {
          nBlockPos = nPos;
          CString strBlock = strLine;
          while ( ( nPos = strLine.Find( m_strBlockEnds[ i ], nPos + 1 ) ) < 0 )
          {
            iFile.getline( strLine.GetBuffer( 1024 ), 1024 );
            strLine.ReleaseBuffer( );
            strBlock += "\n" + strLine;
            nPos = -1;
          }
          strToken = strBlock.Mid( nBlockPos + m_strBlockStarts[ i ].GetLength( ), strBlock.GetLength( ) - nBlockPos - ( strLine.GetLength( ) - nPos ) - m_strBlockEnds[ i ].GetLength( ) );
          ( *m_pfnBlocks[ i ] )( strToken, nData );
          if ( nPos + m_strBlockEnds[ i ].GetLength( ) < strLine.GetLength( ) )
            strLine = strBlock.Left( nBlockPos ) + strToken + strBlock.Mid( strBlock.GetLength( ) - strLine.GetLength( ) + nPos + m_strBlockEnds[ i ].GetLength( ) );
          else
            strLine = strBlock.Left( nBlockPos ) + strToken;
          
          bFound = true;
        }
      }
      
      for ( i = 0; i < m_strTokens.GetSize( ); i++ )
      {
        if ( ( nPos = strLine.Find( m_strTokens[ i ], nTokenPos + 1 ) ) >= 0 )
        {
          nTokenPos = nPos;
          strToken = m_strTokens[ i ];
          ( *m_pfnTokens[ i ] )( strToken, nData );
          strLine = strLine.Left( nTokenPos ) + strToken + strLine.Mid( nTokenPos + m_strTokens[ i ].GetLength( ) );
          bFound = true;
        }
      }

      for ( i = 0; i < m_strEnhancedTokens.GetSize( ); i++ )
      {
        if ( ( nPos = strLine.Find( m_strEnhancedTokens[ i ], nEnhTokenPos + 1 ) ) >= 0 )
        {
          nEnhTokenPos = nPos;
          nPos1 = strLine.Find( m_chDelimiters[ i ], nEnhTokenPos + 1 );
          nPos2 = strLine.Find( m_chDelimiters[ i ], nPos1 + 1 );
          strToken = strLine.Mid( nPos1 + 1, nPos2 - nPos1 - 1 );
          ( *m_pfnEnhancedTokens[ i ] )( strToken, nData );
          strLine = strLine.Left( nPos1 + 1 ) + strToken + strLine.Mid( nPos2 );
          bFound = true;
        }
      }
    }
    while ( bFound );

    *this << strLine << "\n";
  }
}
