#include <CGI.h>
#include <Array.h>
#include <StrClass.h>

typedef void ( *TOKEN_FUNCTION )( CString& strToken, int nFlags );

class CHTMLParser : public CCgi
{
public:
  CHTMLParser( );
  void RegisterToken( CString strToken, TOKEN_FUNCTION pfnToken );
  void RegisterEnhancedToken( CString strToken, char chDelimiter,
                              TOKEN_FUNCTION pfnToken );
  void RegisterBlock( CString strStart, CString strEnd, TOKEN_FUNCTION pfnToken );
  void Parse( const CString& strFile, int nData );

private:
  CHTMLParser& operator=( const CHTMLParser& );

private:
  int m_nFlags;
  CArray< CString, CString& > m_strTokens;
  CArray< TOKEN_FUNCTION, TOKEN_FUNCTION > m_pfnTokens;
  CArray< CString, CString& > m_strEnhancedTokens;
  CArray< char, char > m_chDelimiters;
  CArray< TOKEN_FUNCTION, TOKEN_FUNCTION > m_pfnEnhancedTokens;
  CArray< CString, CString& > m_strBlockStarts;
  CArray< CString, CString& > m_strBlockEnds;
  CArray< TOKEN_FUNCTION, TOKEN_FUNCTION > m_pfnBlocks;
};

inline CHTMLParser& CHTMLParser::operator=( const CHTMLParser& )
{
  // CHTMLReference objects must not be coppied, pass them by reference
  ASSERT( FALSE );

  return *this;
}
