//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: Matrix.h
// Author: Daniel Tschan (d.tschan@switzerland.org)
// Created: 11-02-97
// Last modified: 11-02-97
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// This class template encapsulates an 2-dimensional array (matrix).
//
// TYPE       Type of object stored in the array.
// ARG_TYPE   Type used to reference objects stored in the array.
//            Can be a reference.
//
// This is not yet the final version for TML 1.0!

#ifndef __MATRIX_H__
#define __MATRIX_H__

#include <Decls.h>

template< class TYPE, class ARG_TYPE >
class CMatrix
{
public:
// Construction
  CMatrix( );
  CMatrix( int nRows, int nCols );
  CMatrix( const CMatrix& rOther );

// Destruction
  ~CMatrix( );

// Attributes
  int GetRows( ) const;
  int GetCols( ) const;
  void SetSize( int nRows, int nCols );

// Accessing elements
  TYPE GetAt( int nRow, int nCol ) const;
  void SetAt( int nRow, int nCol, ARG_TYPE newElement );

// overloaded operator helpers
  TYPE operator()( int nRow, int nCol ) const;
  TYPE& operator()( int nRow, int nCol );

// Helper functions
private:
#ifndef NDEBUG
  BOOL InRange( int nRow, int nCol ) const;
#endif
  int Index( int nRow, int nCol ) const;

// Implementation
private:
  TYPE* m_pData;   // the actual array of data
  int m_nRows;     // # of rows
  int m_nCols;     // # of columns
};

// Return TRUE if nRow, nCol is in range otherwise return FALSE
// (debug version only)
#ifndef NDEBUG
template< class TYPE, class ARG_TYPE >
inline BOOL CMatrix< TYPE, ARG_TYPE >::InRange( int nRow, int nCol ) const
{
  return nRow >= 0 && nRow < m_nRows && nCol >= 0 && nCol < m_nCols;
}
#endif

// Map nRow, nCol to a single index
template< class TYPE, class ARG_TYPE >
inline int CMatrix< TYPE, ARG_TYPE >::Index( int nRow, int nCol ) const
{
  return nRow * m_nCols + nCol;
}

// Default constructor
template< class TYPE, class ARG_TYPE >
CMatrix< TYPE, ARG_TYPE >::CMatrix( )
{
  m_nRows = 0;
  m_nCols = 0;
  m_pData = NULL;
}

// Create a matrix with nRows rows and nCols columns
template< class TYPE, class ARG_TYPE >
CMatrix< TYPE, ARG_TYPE >::CMatrix( int nRows, int nCols )
{
  m_nRows = nRows;
  m_nCols = nCols;
  m_pData = new TYPE[ nRows * nCols ];
}

// Copy constructor
template< class TYPE, class ARG_TYPE >
CMatrix< TYPE, ARG_TYPE >::CMatrix( const CMatrix& rOther )
{
  m_nGrowBy = rOther.m_nGrowBy;
  m_nMaxSize = rOther.m_nMaxSize;
  m_nRows = rOther.nRows;
  m_nCols = rOther.nCols;
  m_pData = new TYPE[ m_nRows * m_nCols ];

  // memcpy only works for intrinsics and shallow objects, use a for loop instead
  for ( int i = 0; i < m_nRows * m_nCols; i++ )
    m_pData[ i ] = rOther.m_pData[ i ];
}

template< class TYPE, class ARG_TYPE >
CMatrix< TYPE, ARG_TYPE >::~CMatrix( )
{
  delete [ ] m_pData;
}

template< class TYPE, class ARG_TYPE >
inline int CMatrix< TYPE, ARG_TYPE >::GetRows( ) const
{
  return m_nRows;
}

template< class TYPE, class ARG_TYPE >
inline int CMatrix< TYPE, ARG_TYPE >::GetCols( ) const
{
  return m_nCols;
}

// Resize the matrix to nRows rows and nCols columns.
// All data will be lost!
template< class TYPE, class ARG_TYPE >
void CMatrix< TYPE, ARG_TYPE >::SetSize( int nRows, int nCols )
{
  m_nRows = nRows;
  m_nCols = nCols;
  delete [ ] m_pData;
  m_pData = new TYPE[ nRows * nCols ];
}

template< class TYPE, class ARG_TYPE >
inline TYPE CMatrix< TYPE, ARG_TYPE >::GetAt( int nRow, int nCol ) const
{
  ASSERT( InRange( nRow, nCol ) );
  return m_pData[ Index( nRow, nCol ) ];
}

template< class TYPE, class ARG_TYPE >
inline void CMatrix< TYPE, ARG_TYPE >::SetAt( int nRow, int nCol, ARG_TYPE newElement )
{
  ASSERT( InRange( nRow, nCol ) );
  m_pData[ Index( nRow, nCol ) ] = newElement;
}

template< class TYPE, class ARG_TYPE >
inline TYPE CMatrix< TYPE, ARG_TYPE >::operator()( int nRow, int nCol ) const
{
  ASSERT( InRange( nRow, nCol ) );
  return m_pData[ Index( nRow, nCol ) ];
}

template< class TYPE, class ARG_TYPE >
inline TYPE& CMatrix< TYPE, ARG_TYPE >::operator()( int nRow, int nCol )
{
  ASSERT( InRange( nRow, nCol ) );
  return m_pData[ Index( nRow, nCol ) ];
}

#endif __MATRIX_H__
