//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: RMIServerManager.h
// Author: Daniel Tschan
// Created: 12-09-97
// Last modified: 12-09-97
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// This file contains the interface of the RMI-Server-Manager class.

#ifndef __RMIMANAGER_H__
#define __RMIMANAGER_H__

#include <StrClass.h>

class CRMIServerManager
{
protected:
  // Construction / destruction
  CRMIServerManager( int nPort );
  ~CRMIServerManager( );

  // Method invocation
  int Connections( ) const;
  void ProcessInvokation( );
  void RemoteInvoke( int nFunction );
  virtual void Invoke( int nFunction ) = 0;

  // Parameter exchange
  void PushInt( int n );
  void PushString( const CString& rString );
  int PopInt( );
  CString PopString( );
  
private:
  enum { BACKLOG_SIZE = 10, MAX_CONNECTIONS = 100, STACK_SIZE = 1024, STRING_BUFFERS = 5, BUFFER_SIZE = 256 };
  enum { RMI_INVOKE = 0 };

private:
  void Receive( int nSocket );
  
private:
  UINT m_nListeningSocket;
  UINT m_nMaxHandle;
  UINT* m_pConnections;
  int m_nConnections;
  BYTE* m_pBuffer;
  BYTE* m_pStack;
  BYTE* m_pStackPointer;
};

inline int CRMIServerManager::Connections( ) const
{
  return m_nConnections;
}

#endif // __RMISERVER_H__
