//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: RMIObject.h
// Author: Daniel Tschan (d.tschan@switzerland.org)
// Created: 10-13-97
// Last modified: 12-15-97
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// This file contains the interface of the RMI-Object class.

#ifndef __RMIOBJECT_H__
#define __RMIOBJECT_H__

#include <StrClass.h>
#include <RMIServerFactory.h>

class CRMIObject
{
public:
  virtual ~CRMIObject( );
  void Attach( CRMIServerFactory* pFactory, int nSocket, int nObject );

  // Method invocation
  void RemoteInvoke( int nFunction );
  void ProcessInvokation( int nTimeout = 0 );
  virtual void Invoke( int nFunction ) = 0;

  // Parameter exchange
  void PushInt( int n );
  void PushString( const CString& rString );
  int PopInt( );
  CString PopString( );  

protected:
  CRMIServerFactory* m_pFactory;

private:
  int m_nSocket;
  int m_nObject;
};



inline CRMIObject::~CRMIObject( )
{
}

inline void CRMIObject::ProcessInvokation( BOOL bBlock )
{
  m_pFactory->ProcessInvokation( bBlock );
}

inline void CRMIObject::Attach( CRMIServerFactory* pFactory, int nSocket, int nObject )
{
  m_pFactory = pFactory;
  m_nSocket = nSocket;
  m_nObject = nObject;
}

inline void CRMIObject::RemoteInvoke( int nFunction )
{
  m_pFactory->RemoteInvoke( m_nSocket, m_nObject, nFunction );
}

inline void CRMIObject::PushInt( int n )
{
  m_pFactory->PushInt( n );
}

inline void CRMIObject::PushString( const CString& rString )
{
  m_pFactory->PushString( rString );
}

inline int CRMIObject::PopInt( )
{
  return m_pFactory->PopInt( );
}

inline CString CRMIObject::PopString( )
{
  return m_pFactory->PopString( );
}

#endif   // __RMIOBJECT_H__
