//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: RMIServerFactory.h
// Author: Daniel Tschan
// Created: 10-13-97
// Last modified: 12-15-97
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// This file contains the interface of the CRMIServerFactory class.

#ifndef __RMISERVERFACTORY_H__
#define __RMISERVERFACTORY_H__

#include <StrClass.h>
#include <Array.h>

class CRMIObject;

typedef CArray< CRMIObject*, CRMIObject* > OBJECTS;

class CRMIServerFactory
{
public:
  // Construction / destruction
  CRMIServerFactory( int nPort );
  virtual ~CRMIServerFactory( );

  // Method invocation
  int NumberOfConnections( ) const;
  void ProcessInvokation( int nTimeout = 120 );
  void RemoteInvoke( int nSocket, int nObject, int nFunction );
 
  // Parameter exchange
  void PushInt( int n );
  void PushString( const CString& rString );
  int PopInt( );
  CString PopString( );
  virtual CRMIObject* CreateObject( int nClassID ) = 0;

protected:
  int NumberOfObjects( int nConnection ) const;
  CRMIObject* GetObject( int nConnection, int nObject ) const;

private:
  enum { BACKLOG_SIZE = 10, STACK_SIZE = 2048 };
  enum { RMIF_INVOKE = 0, RMIF_RETURN = 1, RMIF_CREATE_INSTANCE = 2 };

private:
  void Receive( int nSocket );
  void CreateLocalInstance( int nSocket, int nClassID );
  void Send( int nSocket, int nServerFunction );
  void Sync( );
  int Align32( int n );

protected:
  CArray< OBJECTS, OBJECTS& > m_objects;

private:
  CArray< int, int > m_connections;
  int m_nPendingInvokations;
  
  UINT m_nListeningSocket;
  UINT m_nMaxHandle;
  BYTE* m_pBuffer;
  BYTE* m_pStack;
  BYTE* m_pStackPointer;
};

inline int CRMIServerFactory::NumberOfConnections( ) const
{
  return m_connections.GetSize( );
}

inline int CRMIServerFactory::NumberOfObjects( int nConnection ) const
{
  return m_objects[ nConnection ].GetSize( );
}

inline CRMIObject* CRMIServerFactory::GetObject( int nConnection, int nObject ) const
{
  return m_objects[ nConnection ][ nObject ];
}

#endif // __RMISERVER_H__
