//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: Random.cpp
// Author: Daniel Tschan
// Created: 10-13-97
// Last modified: 10-23-97
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML

#include <time.h>
#include <Random.h>

CRandom::CRandom( )
{
  m_pRand = NULL;
}

CRandom::~CRandom( )
{
  delete [ ] m_pRand;
}

void CRandom::Shuffle( CString strKey )
{
  if ( strKey.IsEmpty( ) )
  {
    time_t tm;

    time( &tm );
    strKey = ctime( &tm );
  }

  // At least one byte of the prefix key must be even!
  strKey = CString( "TML Version 1.0" + strKey + CString( ' ', 82 ), 97 );
  
  if ( m_pRand == NULL )
    m_pRand = new int[ 100 ];
  
  int i;
  for ( i = 0; i < 97; i++ )
    m_pRand[ i ] = strKey[ i ] * 8171717 + ( i + 1 ) * 997;
  
  int nIndex1 = 96;
  int nIndex2 = 11;
  
  for ( i = 0; i < 997; i++ )
  {
    m_pRand[ nIndex1 ] -= m_pRand[ nIndex2 ];
    
    if ( m_pRand[ nIndex1 ] < 0 )
      m_pRand[ nIndex1 ] += 1000000000;
    
    if ( nIndex1 > 0 )
      nIndex1--;
    else
      nIndex1 = 96;
    
    if ( nIndex2 > 0 )
      nIndex2--;
    else
      nIndex2 = 96;
  }

  m_pRand[ 97 ] = 54;
  m_pRand[ 98 ] = 23;
  m_pRand[ 99 ] = 76;
}

int CRandom::Rand( )
{
  int nIndex1 = m_pRand[ 97 ];
  int nIndex2 = m_pRand[ 98 ];

  int nNumber = m_pRand[ nIndex1 ] - m_pRand[ nIndex2 ];
  
  if ( nNumber < 0 )
    nNumber += 1000000000;
  
  m_pRand[ nIndex1 ] = nNumber;
  
  if ( nIndex1 > 0 )
    m_pRand[ 97 ] = nIndex1 - 1;
  else
    m_pRand[ 97 ] = 54;
  
  if ( nIndex2 > 0 )
    m_pRand[ 98 ] = nIndex2 - 1;
  else
    m_pRand[ 98 ] = 54;

  nIndex1 = m_pRand[ 99 ] % 42 + 55;
  
  m_pRand[ 99 ] = m_pRand[ nIndex1 ];
  
  m_pRand[ nIndex1 ] = nNumber;

  return m_pRand[ 99 ];
}
