//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: Random.h
// Author: Daniel Tschan
// Created: 10-13-97
// Last modified: 10-23-97
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// This class provides an enhanced pseudorandom-number generator and several
// member functions to modify its output. The series of generated numbers is
// very big (over 2^55 numbers). Beside of this it is much faster then the
// rand function (about 6 times).

#include <math.h>
#include <StrClass.h>

class CRandom
{
public:
  CRandom( );
  ~CRandom( );
  void Shuffle( CString strKey = "" );
  int Rand( );
  double Exponential( double dMean );
  double Frac( );
  int Integer( int nMin, int nMax );
  double Normal( double dMean, double dStdDev );
  double Real( double dMin, double dMax );

private:
  int* m_pRand;
};

inline double CRandom::Frac( )
{
  return Rand( ) / 1.0E9;
}

inline double CRandom::Exponential( double dMean )
{
  return -dMean * log( Frac( ) );
}


inline int CRandom::Integer( int nMin, int nMax )
{
  return nMin + ( Rand( ) % ( nMax - nMin + 1 ) );
}

inline double CRandom::Normal( double dMean, double dStdDev )
{
  return dMean + dStdDev * sqrt( -2.0 * log( Frac( ) ) ) *
         cos( 6.283185 * Frac( ) );
}

inline double CRandom::Real( double dMin, double dMax )
{
  return dMin + ( dMax - dMin ) * ( Rand( ) / 1.0E9 );
}

