#ifndef __SKIPLISTNODE_H__
#define __SKIPLISTNODE_H__

#include <string.h>

template< class KEY, class ARG_KEY, class VALUE, class ARG_VALUE >
class CSkipListNode
{
public:
  CSkipListNode( int nLevels );
  CSkipListNode( int nLevels, ARG_KEY key );
  ~CSkipListNode( );
  
public:
  KEY m_key;
  VALUE m_value;
  CSkipListNode** m_ppNext;
};

template< class KEY, class ARG_KEY, class VALUE, class ARG_VALUE >
CSkipListNode< KEY, ARG_KEY, VALUE, ARG_VALUE >::CSkipListNode( int nLevels )
{
  m_ppNext = new CSkipListNode*[ nLevels ];
  memset( m_ppNext, 0, sizeof( CSkipListNode* ) * nLevels );
}

template< class KEY, class ARG_KEY, class VALUE, class ARG_VALUE >
CSkipListNode< KEY, ARG_KEY, VALUE, ARG_VALUE >::
  CSkipListNode( int nLevels, ARG_KEY key )
{
  m_key = key;
  m_ppNext = new CSkipListNode*[ nLevels ];
  memset( m_ppNext, 0, sizeof( CSkipListNode* ) * nLevels );
}

template< class KEY, class ARG_KEY, class VALUE, class ARG_VALUE >
CSkipListNode< KEY, ARG_KEY, VALUE, ARG_VALUE >::~CSkipListNode( )
{
  delete [ ] m_ppNext;
}

#endif   // __SKIPLISTNODE_H__
