#include <StdioFile.h>

CStdioFile::CStdioFile( )
{
  m_pStream = NULL;
}

CStdioFile::CStdioFile( FILE* pOpenStream )
{
  ASSERT( pOpenStream );

  m_pStream = pOpenStream;
}

CStdioFile::CStdioFile( const char* lpszFileName, unsigned int nOpenFlags )
{
  ASSERT( lpszFileName );

  Open( lpszFileName, nOpenFlags );
}

CStdioFile::~CStdioFile( )
{
}

BOOL CStdioFile::Open( const char* lpszFileName, unsigned int nOpenFlags )
{
  CString strMode;

  if ( nOpenFlags & ( modeCreate | modeRead | modeWrite ) )
    strMode = "w+";
  else if ( nOpenFlags & ( modeCreate | modeWrite ) )
    strMode = "w";
  else if ( nOpenFlags & ( modeRead | modeWrite ) )
    strMode = "r+";
  else
    strMode = "r";
  
  m_pStream = fopen( lpszFileName, strMode );

  return m_pStream != NULL;
}

unsigned int CStdioFile::GetLength( ) const 
{
  unsigned int nPos = ftell( m_pStream );
  unsigned int nSize = fseek( m_pStream, 0, SEEK_END );
  fseek( m_pStream, nPos, SEEK_SET );

  return nSize;
}

BOOL CStdioFile::ReadString( CString& rString )
{
  char* lpszResult = fgets( rString.GetBuffer( 1024 ), 1024, m_pStream );
  rString.ReleaseBuffer( );

  return lpszResult != NULL;
}
