#include <stdio.h>
#include <File.h>
#include <StrClass.h>

class CStdioFile : public CFile
{
public:
  // Construction
  CStdioFile( );
  CStdioFile( FILE* pOpenStream );
  CStdioFile( const char* lpszFileName, unsigned int nOpenFlags );
  ~CStdioFile( );
  virtual BOOL Open( const char* lpszFileName, unsigned int nOpenFlags ); //, CFileException* pError = NULL );
  virtual void Close( );

  // Input/Output
  virtual unsigned int Read( void* lpBuf, unsigned int nCount );
  virtual void Write( const void* lpBuf, unsigned int nCount );
  virtual void Flush( );

  // Text Read/Write
  virtual char* ReadString( char* lpsz, unsigned int nMax );
  BOOL ReadString( CString& rString );
  virtual void WriteString( const char* lpsz );

  // Position
  virtual long Seek( long lOff, unsigned int nFrom );
  virtual unsigned int GetLength( ) const;
  
  // Status
  virtual unsigned int GetPosition( ) const;  

public:
  FILE* m_pStream;
};
  
inline void CStdioFile::Close( )
{
  if ( m_pStream != NULL )
    fclose( m_pStream );
}

inline unsigned int CStdioFile::Read( void* lpBuf, unsigned int nCount )
{
  ASSERT( lpBuf );
  ASSERT( nCount > 0 );

  return fread( lpBuf, 1, nCount, m_pStream );
}

inline void CStdioFile::Write( const void* lpBuf, unsigned int nCount )
{
  ASSERT( lpBuf );
  ASSERT( nCount > 0 );

  fwrite( lpBuf, 1, nCount, m_pStream );
}

inline void CStdioFile::Flush( )
{
  fflush( m_pStream );
}

inline long CStdioFile::Seek( long lOff, unsigned int nFrom )
{
  return fseek( m_pStream, lOff, nFrom );
}

inline unsigned int CStdioFile::GetPosition( ) const
{
  return ftell( m_pStream );
}

inline char* CStdioFile::ReadString( char* lpsz, unsigned int nMax )
{
  ASSERT( lpsz );
  ASSERT( nMax > 0 );

  return fgets( lpsz, nMax, m_pStream );
}

inline void CStdioFile::WriteString( const char* lpsz )
{
  fputs( lpsz, m_pStream );
}

