//////////////////////////////////////////////////////////////////////////////
// The Magic Library Version 1.0
//
// File: TreeBuffer.h
// Author: Daniel Tschan (d.tschan@switzerland.org)
// Created: 11-08-97
// Last modified: 11-09-97
// Documentation: http://iamexwiwww.unibe.ch/studenten/tschan/TML
//
// Low-level class for buffer managing. This class is used to build high-level
// classes like linked lists, binary trees, quad trees and so on.

#ifndef __TREEBUFFER_H__
#define __TREEBUFFER_H__

#include <Buffer.h>

class CTreeBufferNode   // warning: variable length object
{
  TYPE m_data;
  CTreeBufferNode* p;
}

template< class TYPE >
class CTreeBuffer
{
public:
// Construction / Destruction
  CTreeBuffer( int nBlockSize = 8 );
  ~CTreeBuffer( );
  
// Resizing
  TYPE* NewBlock( );
  
private:
  
  class CBlock   // warning: variable length object
  {
  public:
    CBlock* m_pNext;
    BYTE* m_pbyData;
  };

private:
  int m_nBlockSize;   // number of elements a block contains
  CBlock* m_pHead;   // the linked memory blocks
};



template< class TYPE >
CLinkedBuffer< TYPE >::CLinkedBuffer( int nBlockSize )
{
  m_nBlockSize = nBlockSize;
  m_pHead = NULL;
}

template< class TYPE >
CLinkedBuffer< TYPE >::~CLinkedBuffer( )
{
  CBlock* pNext;
  CBlock* pBlock = m_pHead;

  while ( pBlock != NULL )
  {
    pNext = pBlock->m_pNext;
    DestructElements( pBlock->m_data, m_nBlockSize );
    delete [ ] ( BYTE* ) pBlock;
    pBlock = pNext;
  }
}

template< class TYPE >
TYPE* CTreeBuffer< TYPE >::NewBlock( )
{
  CBlock* pBlock = ( CBlock* ) new BYTE[ sizeof CBlock + sizeof( TYPE ) * m_nBlockSize ];
  ConstructElements( pBlock->m_data, m_nBlockSize );

  // add in reverse order for simplicity
  pBlock->m_pNext = m_pHead;
  m_pHead = pBlock;

  return pBlock->m_data;
}

#endif // __TREEBUFFER_H__
